//////////////////////////////////////////////////////////////////////////////
// asp_core.C

#include "asp_core.h"

//////////////////////////////////////////////////////////////////////////////
// Global variables

const char*  WhoAmI;
unsigned    OptionVerbosity            = 0;

//////////////////////////////////////////////////////////////////////////////
// Frontend-specific stuff.

unsigned    parser_line;
static const char* parser_file;
unsigned    parser_errors   = 0;
bool        ParserStateInternal = true;

//////////////////////////////////////////////////////////////////////////////
// Helper functions as expected by LEX/FLEX

extern "C" int yywrap()    // End-of-file handler for LEX
    {
    return 1;
    }

extern "C" FILE* yyin;     // Where LEX reads its input from

//////////////////////////////////////////////////////////////////////////////
// Helper functions as expected by YACC/BISON

int yyerror(const char* s) // Error handler for YACC
    {
    if( !ParserStateInternal )
        {
        if( OptionVerbosity )
            cerr << WhoAmI << " (";

        if( strlen(parser_file) > 0 )
            cerr << parser_file << ": ";
        cerr << "line " << parser_line;

        if( OptionVerbosity )
            cerr << ')';

        cerr << ": ";
        }
    else
        cerr << "Internal parser invocation: ";

    cerr << s << "." << endl;

    return 0;
    }

#include "parser_asp_core2.c"

//////////////////////////////////////////////////////////////////////////////
static void printUsage(ostream &out)
//
    {
     out  << "usage: " << WhoAmI 
         <<  " [filename [filename [...]]]" << endl
         << endl;
    }

////////////////////////////////////////////////////////////////////
// Main Function
int main(int argc, char* argv[])
    {
#ifdef BISON_DEBUG
    yydebug = 1;                   // Set to 1, and YACC will output debug info
#endif
    WhoAmI = argv[0];

    // Analyse command-line switches (any parameter starting with a dash is
    // considered a switch) and count the number of filenames provided.
    unsigned filenames=0;

    for(int i=1; i < argc; i++)
        filenames++;


    // While parsing user input, we don't accept INTERNAL_IDs.
    ParserStateInternal = false;

        if( argc < 2 )
        {
            printUsage(cout);
            return 0;
        }
   
    for(int i = 1; i < argc; i++)
    {
        if( !strcmp(argv[i],"--help") )
        {
            printUsage(cout);
            return 0;
        }
        parser_file=argv[i];
        parser_line=0;
        FILE* fp = fopen(parser_file,"r");
        if( fp )
        {
            if( OptionVerbosity )
                cout << "Reading \"" << parser_file << "\"" << endl;
            parser_line=1;
                
            yyin=fp;
            yyparse();
            fclose(yyin);                    
        }
        else
            yyerror("can't open input");
    }
    ParserStateInternal = true;

    if( parser_errors )
        {
        cerr << "Aborting due to parser errors." << endl;

        exit( EXIT_FAILURE );
        }
        
    exit( EXIT_SUCCESS );
    }
