%{
//////////////////////////////////////////////////////////////////////////////
// parser.y

//////////////////////////////////////////////////////////////////////////////
%}
%error-verbose
%union {
	char*          string;
}

%token <string> SYMBOLIC_CONSTANT NUMBER VARIABLE STRING

%token ERROR NEWLINE

%token DOT CONS ID_OR_VEL QUERY_MARK

%token PLUS TIMES SLASH

%token ANON_VAR

%token PARAM_OPEN PARAM_CLOSE
%token SQUARE_OPEN SQUARE_CLOSE
%token CURLY_OPEN CURLY_CLOSE

%token EQUAL UNEQUAL LESS GREATER LESS_OR_EQ GREATER_OR_EQ

%token DASH TILDE COMMA NAF

%token VEL

%start program
%%

HEAD_SEPARATOR  : ID_OR_VEL | VEL;

BODY_SEPARATOR  : COMMA;

TERM_SEPARATOR  : COMMA;

MINUS  : DASH;

NEG: DASH | TILDE

program   : 
		  | rules
		  | rules query
		  | error { parser_errors++; }
          ;

rules     : rules rule
          | rule
		  ;

rule	  : head DOT {}
          | head CONS DOT {}
          | head CONS body DOT {}
		  | CONS body DOT /*constraint*/ {}
          ;

head      : classic_literal {}
          | head HEAD_SEPARATOR classic_literal {}
          ;		

body      : body_element {}
          | body BODY_SEPARATOR body_element {}
          ;
		  
body_element : naf_literal {}
			 | builtin_atom {}
			 ;		

naf_literal  : classic_literal {}
			 | NAF classic_literal {}
			 ;

classic_literal  : atom {}
				 | NEG atom {}
				 ;	

atom : 	  identifier
          | identifier PARAM_OPEN terms PARAM_CLOSE {}
		  | identifier PARAM_OPEN PARAM_CLOSE {}
          ;				 
		 
terms    : term	{}
         | terms TERM_SEPARATOR term	{}
         ;

builtin_atom	: term binop term {}
				| term binop term arithop term{} 
				;
		 
binop    : compareop     {} 
          | leftwardop   {}
          | rightwardop  {}
          ;	
		 
compareop : EQUAL         {} 
          | UNEQUAL       {}
          ; 
		  
leftwardop 	: LESS {}
			| LESS_OR_EQ {}
			;    
 
rightwardop : GREATER {}
			| GREATER_OR_EQ {}
			;		 
		   
arithop   : PLUS     {} 
          | MINUS    {}
          | TIMES    {}
          | SLASH    {}
          ;		 

term     : identifier   {}
         | ANON_VAR     {}
         | NUMBER       {} 
         ;
		 
identifier 	: SYMBOLIC_CONSTANT {}
			| STRING {}
            | ID_OR_VEL {}
			| VARIABLE {}
			;
				
query     : atom QUERY_MARK {}
          ;	

%%

// Local Variables:
// mode: c++
// End:
