//////////////////////////////////////////////////////////////////////////////
// asp_rfc.h

#ifndef ASP_RFC_H
#define ASP_RFC_H

#define HAVE_GCC_VERSION(MAJOR, MINOR) \
  (__GNUC__ > (MAJOR) || (__GNUC__ == (MAJOR) && __GNUC_MINOR__ >= (MINOR)))
  
#include <iostream>
#include <string.h>
#include <assert.h>

//////////////////////////////////////////////////////////////////////////////
// Global Settings

#define NUM_LENGTH 9

//////////////////////////////////////////////////////////////////////////////
// Debugging

#define cdebug cerr
#define cstats cerr

// If BISON_DEBUG is set, set YYDEBUG to != 0 so that bison will generate
// code for the variables yydebug, diagyydebug, sqlyydebug (and possibly
// further ones).

#ifdef BISON_DEBUG
#define YYDEBUG 1
#endif

//////////////////////////////////////////////////////////////////////////////
// Global Options (usually set from the command-line)

extern unsigned   OptionVerbosity;

extern unsigned   parser_line;
extern unsigned   parser_errors;
extern bool       ParserStateInternal;

//////////////////////////////////////////////////////////////////////////////
// Misc

namespace std { }

using namespace std;

//////////////////////////////////////////////////////////////////////////////
// Global Variables

extern const char*  WhoAmI;

/////////////////////////////////////////////////////////////////
// Bug Fixes for Various Environments

// BUG-FIX: bison[1.24] fails to prototype its interfaces yylex() and yyerror().
extern "C" int yylex();
extern "C" int yyerror(const char*);

#endif
