%{
//////////////////////////////////////////////////////////////////////////////
// parser.y

//////////////////////////////////////////////////////////////////////////////
%}
%error-verbose
%union {
    char*          string;
}

%token <string> SYMBOLIC_CONSTANT NUMBER VARIABLE STRING

%token ERROR NEWLINE   

%token DOT COLON CONS ID_OR_VEL QUERY_MARK

%token PLUS TIMES SLASH

%token ANON_VAR

%token PARAM_OPEN PARAM_CLOSE
%token SQUARE_OPEN SQUARE_CLOSE
%token CURLY_OPEN CURLY_CLOSE

%token EQUAL UNEQUAL LESS GREATER LESS_OR_EQ GREATER_OR_EQ

%token DASH TILDE COMMA NAF

%token VEL AGGR_COUNT AGGR_MAX AGGR_MIN AGGR_SUM

%start program
%%

HEAD_SEPARATOR  : ID_OR_VEL | VEL;

BODY_SEPARATOR  : COMMA;

TERM_SEPARATOR  : COMMA;

MINUS  : DASH;

NEG: DASH | TILDE

program   : 
          | rules
          | rules query
          | error { parser_errors++; }
          ;

rules   : rules rule
          | rule
          ;

rule      : head DOT {}
          | head CONS DOT {}
          | head CONS body DOT {}
          | CONS body DOT /*constraint*/ {}
          ;

head      : classic_literal {}
          | head HEAD_SEPARATOR classic_literal {}
          ;       

body      : body_element {}
          | body BODY_SEPARATOR body_element {}
          ;
          
body_element : naf_literal {}
             | builtin_atom {}
             ;
          
naf_literal  : classic_literal {}
             | NAF classic_literal {}
             | aggregate {}
             | NAF aggregate {}
             ;      

classic_literal  : atom {}
                 | NEG atom {}
                 ;  

atom :    identifier
          | identifier PARAM_OPEN terms PARAM_CLOSE {}
          | identifier PARAM_OPEN PARAM_CLOSE {}
          ;              
         
terms    : term {}
         | terms TERM_SEPARATOR term    {}
         ;

builtin_atom    : term binop term {}
                | term binop term arithop term{} 
                ;

compareop : EQUAL         {} 
          | UNEQUAL       {}
          ;       
         
binop    : compareop     {} 
         | leftwardop        {}
         | rightwardop       {}
         ;       
         
arithop   : PLUS     {} 
          | MINUS    {}
          | TIMES    {}
          | SLASH      {}
          ;      

term     : identifier   {}
         | ANON_VAR         {}
         | NUMBER           {} 
         | function_term    {}
         ;        
         
identifier  : SYMBOLIC_CONSTANT {}
            | STRING {}
            | ID_OR_VEL {}
            | VARIABLE {}
            ;
                
query     : atom QUERY_MARK {}
          ; 

compare_aggregate : term compareop aggregate_atom {}
                  | aggregate_atom compareop term {}            
                  ;

leftward_left_aggregate  : term leftwardop aggregate_atom {}
						 ;
left_aggregate : leftward_left_aggregate
               | rightward_left_aggregate {}
			   ;

rightward_left_aggregate  : term rightwardop aggregate_atom {}
						  ;
						  
right_aggregate : aggregate_atom leftwardop term {}
                |  aggregate_atom rightwardop term {}
			    ;

aggregate   : left_aggregate {}
            | right_aggregate {}
            | compare_aggregate {}
            | leftward_left_aggregate leftwardop term {}
            | rightward_left_aggregate rightwardop term {}
            ;   

leftwardop : LESS {}
       | LESS_OR_EQ {}
       ;    

rightwardop : GREATER {}
        | GREATER_OR_EQ {}
        ;           
            
aggregate_atom  : aggregate_function CURLY_OPEN variables COLON conjunction CURLY_CLOSE {}
                | CURLY_OPEN variables COLON conjunction CURLY_CLOSE {}
                | SQUARE_OPEN variables COLON conjunction SQUARE_CLOSE {}
                ;
				
variables   : VARIABLE {}
            | variables TERM_SEPARATOR VARIABLE   {}
            ;

conjunction : aggregate_element {}
            | conjunction BODY_SEPARATOR aggregate_element   {}
            ;
			
aggregate_element	: atom {}
					| builtin_atom {}
					;

aggregate_function  : AGGR_COUNT {}
                    | AGGR_MAX {}
                    | AGGR_MIN {}
                    | AGGR_SUM {}
                    ;   

function_term   : identifier PARAM_OPEN terms PARAM_CLOSE 
                ;                       

%%

// Local Variables:
// mode: c++
// End:
