%{
/////////////////////////////////////////////////////////////////////////////
// scanner_asp_rfc.l

#include "parser_asp_rfc.h"

#if defined(__WIN32__) || defined(__MINGW32__) || defined(__CYGWIN__)
    #define isatty(x) 0 /* hack for bug in flex 2.5.35 on some platforms */
#endif



%}

%option nounput

BLANK       ([ \t]+)
NEWLINE     \15?\n
COMMENT     \%.*

SYMBOLIC_CONSTANT 	([a-z][A-Za-z_0-9]*)
VARIABLE     	    ([_A-Z][A-Za-z_0-9]*)
STRING  			(\"[^\"]*\")
ANON_VAR       		_
NUMBER         		([0-9]+)

%START WANT_NEWLINE
		       //Only in state WANT_NEWLINE a newline
		       // token for the parser is generated, while
		       // normally newlines are simply skipped.
		       
%%
        // Newline is normally skipped, except when explicitly
		// requested with WANT_NEWLINE. (e.g. by a construct that is
		// terminated by a newline.)
	
<WANT_NEWLINE>{NEWLINE} { 
			parser_line++;
			BEGIN(INITIAL);
			return NEWLINE;
			}
{NEWLINE}	{ parser_line++;    }

"."			{ return DOT;		}

","			{ return COMMA;		}

"|"         |
";"			{ return VEL; }
"v"		    { return ID_OR_VEL;  }

"~"		    { return TILDE;  }

"not"       { return NAF;    }

"<-"		| 
":-"		{ return CONS;	}

"+"			{ return PLUS;	}
"-"         { return DASH;  }
"*"			{ return TIMES;	}
"/"         | 
"div"		{ return SLASH; }

"("			{ return PARAM_OPEN;	}
")"			{ return PARAM_CLOSE;	}

"["			{ return SQUARE_OPEN;	}
"]"			{ return SQUARE_CLOSE;	}

"{"			{ return CURLY_OPEN;	}
"}"			{ return CURLY_CLOSE;	}

"=="		|
"="			{ return EQUAL;}
"<>"		|
"!="		{ return UNEQUAL;}
"<"			{ return LESS;}
">"			{ return GREATER;}
"<="		{ return LESS_OR_EQ;}
">="		{ return GREATER_OR_EQ;}

"?"			{ return QUERY_MARK;}

":"         { return COLON; }

"#count"    { return AGGR_COUNT;            }
"#max"      { return AGGR_MAX;              }
"#min"      { return AGGR_MIN;              }
"#sum"      { return AGGR_SUM;              }

{SYMBOLIC_CONSTANT}		{
							yylval.string=new char[strlen(yytext)+1];
							strcpy(yylval.string,yytext);
							return SYMBOLIC_CONSTANT;
						}

{VARIABLE}			    {
							yylval.string=new char[strlen(yytext)+1];
							strcpy(yylval.string,yytext);
							return VARIABLE;
						}

{STRING}				{
							yylval.string=new char[strlen(yytext)+1];
							strcpy(yylval.string,yytext);
							return STRING;
						}

{NUMBER}				{ 
						    yylval.string=new char[strlen(yytext)+1];
							strcpy(yylval.string,yytext);
							return NUMBER; 
						}
							
\%.*			{ /* Skip comments */	}
{BLANK}			{ /* Skip blanks */	}

.				{ // Anything not matching one of the patterns
				 // given above is considered an error.
					char s[1024];
					assert(yytext[1]==0);
					sprintf(s,"Lexical syntax error (%s)",yytext); 
					yyerror(s);
		
					parser_errors++;
                    return ERROR;
				}
