//============================================================================
/*
Random selector for instances of the 2014 ASP Competition.
Copyright (C) Francesco Ricca 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
(http://www.gnu.org/licenses/gpl-2.0.html)
*/
//============================================================================

#include <iostream>
#include <vector>
#include <stdlib.h>

using namespace std;

int main(int argc, char **argv) {

	unsigned seed = atoi(argv[1]);
	unsigned num = atoi(argv[2]);
	vector<string> instances;

	srand(seed);

	for (std::string line; std::getline(std::cin, line);) {
		instances.push_back(line);
	    }

	if(instances.size() <= num)
	{
		cerr << "WARNING: all instances considered" << endl;
		for(unsigned i = 0; i < instances.size(); ++i)
		{
			cout << instances[i];
			cout << endl;
		}
		return 0;
	}

	while(num >0)
	{
		unsigned extract = static_cast<unsigned>(rand()%instances.size());
		//cout << extract << endl;
		cout << instances[extract];
		cout << endl;
		instances[extract] = instances[instances.size()-1];
		instances.pop_back();
		num--;
	}

	return 0;
}
