#!/bin/bash
# by F. Ricca
# Selector for instances of the 2014 ASP Competition.
# Copyright (C) Francesco Ricca

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# (http://www.gnu.org/licenses/gpl-2.0.html)

if [ $# -lt 3 ]; then
    echo "This script must be invoked with at least two parameters!"
    echo select seed number suite 
    exit
fi

# Absolute path to this script
scriptpath=$(readlink -e "$0")
# Absolute path this script is in
DIRNAME=$(dirname "$scriptpath")

seed=$1
number=$2
suite=$3

if [ ! -e "$suite" ]; then
   echo "ERROR: Suite folder $suite not found"
   echo -n "       Execution aborted "; date
   exit 1
fi

for d in `ls $suite`; do

  ls $suite/$d | grep asp | grep -v encoding | sort | $DIRNAME/instance-selector $seed $number > instances.competition.$d

done

