#hide.
#show valid/0.

% unsat
true(X) | false(X)  :- atom(X).

% check if the guess is not a model for each fs and the negated claim
subformula(X) :- to_check(X).
valid :- ismodel(X), to_check(X).

% constraint if fs's do not entail claim
:- not valid.

% saturate (this ensures that we consider every interpretation!)
true(X) :- valid, atom(X).
false(X) :- valid, atom(X).

%% Subformulae

% splitting a formula into its subformulas
subformula(F) :- subformula(and(F,_)).
subformula(F) :- subformula(and(_,F)).
subformula(F) :- subformula(or(_,F)).
subformula(F) :- subformula(or(F,_)).
subformula(F) :- subformula(neg(F)).
subformula(F) :- subformula(xor(F,_)).
subformula(F) :- subformula(xor(_,F)).
subformula(F) :- subformula(imp(F,_)).
subformula(F) :- subformula(imp(_,F)).
subformula(F) :- subformula(iff(F,_)).
subformula(F) :- subformula(iff(_,F)).

% decide whether a subformula is an atom or not
noatom(F) :- subformula(F;F1;F2), F:=and(F1,F2).
noatom(F) :- subformula(F;F1;F2), F:=or(F1,F2).
noatom(F) :- subformula(F;F1), F:=neg(F1).
noatom(F) :- subformula(F;F1;F2), F:=xor(F1,F2).
noatom(F) :- subformula(F;F1;F2), F:=imp(F1,F2).
noatom(F) :- subformula(F;F1;F2), F:=iff(F1,F2).

atom(X) :- subformula(X), not noatom(X), not assigned_true(X), not assigned_false(X).
atomc(X) :- subformula(X), X:=c(v).
atomc(X) :- subformula(X), X:=c(f).


%% Model Check

% check whether an interpretation is a model or not
% K specifies a key for identifying the origin of the second parameter (formula)

ismodel(X) :- atom(X), true(X).
ismodel(X) :- atomc(X), X:=c(v).
ismodel(X) :- assigned_true(X).
ismodel(F) :- subformula(F;F1), F:=neg(F1), nomodel(F1).
ismodel(F) :- subformula(F), F:=and(F1,F2), ismodel(F1;F2).
ismodel(F) :- subformula(F;F1;F2), F:=or(F1,F2), ismodel(F1).
ismodel(F) :- subformula(F;F1;F2), F:=or(F1,F2), ismodel(F2).
ismodel(F) :- subformula(F), F:=xor(F1,F2), ismodel(F1), nomodel(F2).
ismodel(F) :- subformula(F), F:=xor(F1,F2), ismodel(F2), nomodel(F1).
ismodel(F) :- subformula(F;F1;F2), F:=imp(F1,F2), nomodel(F1).
ismodel(F) :- subformula(F), F:=imp(F1,F2), ismodel(F1;F2).
ismodel(F) :- subformula(F), F:=iff(F1,F2), ismodel(F1;F2).
ismodel(F) :- subformula(F), F:=iff(F1,F2), nomodel(F1;F2).

nomodel(X) :- atom(X), false(X).
nomodel(X) :- atomc(X), X:=c(f).
nomodel(X) :- assigned_false(X).
nomodel(F) :- subformula(F;F1), F:=neg(F1), ismodel(F1).
nomodel(F) :- subformula(F;F1;F2), F:=and(F1,F2), nomodel(F1).
nomodel(F) :- subformula(F;F1;F2), F:=and(F1,F2), nomodel(F2).
nomodel(F) :- subformula(F), F:=or(F1,F2), nomodel(F1;F2).
nomodel(F) :- subformula(F), F:=xor(F1,F2), ismodel(F1;F2).
nomodel(F) :- subformula(F), F:=xor(F1,F2), nomodel(F1;F2).
nomodel(F) :- subformula(F), F:=imp(F1,F2), ismodel(F1), nomodel(F2).
nomodel(F) :- subformula(F), F:=iff(F1,F2), nomodel(F1), ismodel(F2).
nomodel(F) :- subformula(F), F:=iff(F1,F2), nomodel(F2), ismodel(F1).
