#! /bin/bash
#set -x
read answerRow

checker_path="$(dirname "$0")"

# Erroneous result/exit code combos
if [ "$answerRow" == "INCONSISTENT" ] && [ $1 != 20 ]; then
    echo "FAIL"
    echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT"  >&2
    exit 1
fi
if [ "$answerRow" != "INCONSISTENT" ] && [ $1 == 20 ]; then
    echo "FAIL"
    echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT"  >&2
    exit 1
fi
if [ "$answerRow" != "UNKNOWN" ] && [ $1 != 10 ] && [ $1 != 20 ]; then
    echo "FAIL"
    echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT"  >&2
    exit 1
fi

# Negative instances
if [ $1 == 20 ]; then
    echo "DONTKNOW"
    echo "Instances with no solution should not be checked with this checker" >&2
    exit 2
else
    # Positive instances
    if [ $1 == 10 ]; then 
	systemResult=$(cat ${2} | sed -e 's/:-\(.*\)/error:-\1/g' | $checker_path/gringo - $checker_path/metaASP_chk.asp <(echo "$answerRow") | $checker_path/clasp --outf=1 2>&1)
	chkexit=$?
	if [[ $chkexit -eq 20 && -f ${2} ]] ; then
	    echo "OK"
	    exit 0
	elif [[ $chkexit -eq 10 && -f ${2} ]] ; then
	    echo "FAIL"
	    exit 1
#	elif [[ $chkexit -eq 1 && $systemResult =~ (\s)*ERROR ]] ; then
	else # if [[ $chkexit -eq 1 || ! -f ${2} ]] ; then
    	    echo "WARN"
    	    echo "Unrecognized input stream or general checker failure." >&2
    	    exit 3
	fi
    # Uknown exit code
    else
	echo "FAIL"
	exit 1
    fi
fi
