% extract body elements

litb(B) :- rule(_,B).
% litb(E) :- litb(pos(conjunction(S))), set(S,E).
% litb(E) :- eleb(sum(_,S,_)), wlist(S,_,E,_).
% litb(E) :- eleb(min(_,S,_)), wlist(S,_,E,_).
% litb(E) :- eleb(max(_,S,_)), wlist(S,_,E,_).

eleb(P) :- litb(pos(P)).
% eleb(N) :- litb(neg(N)).

% check claimed answer set

holD(conjunction(S)) :- eleb(conjunction(S)),
                        holD(P) : set(S,pos(P)), not hold(N) : set(S,neg(N)).
holD(atom(A))        :- rule(pos(atom(A)),   pos(B)), holD(B).
holD(atom(A))        :- rule(pos(sum(L,S,U)),pos(B)), holD(B),
                        wlist(S,_,pos(atom(A)),_), hold(atom(A)).

error(pos(hold(E))) :- hold(E), not holD(E).
error(neg(hold(E))) :- holD(E), not hold(E).
error(neg(sum(L,S,U))) :- rule(pos(sum(L,S,U)),pos(B)), hold(B),
         not L #sum  [     hold(P) = W : wlist(S,Q,pos(P),W),
                       not hold(N) = W : wlist(S,Q,neg(N),W) ] U.
error(pos(B)) :- rule(pos(false),pos(B)), hold(B).

err :- error.
err :- error(_).

% guess counterexample

told(conjunction(S)) :- eleb(conjunction(S)), optimize(1,1,incl), not err,
                        told(P) : set(S,pos(P)), not told(N) : set(S,neg(N)).
told(atom(A))        :- rule(pos(atom(A)),   pos(B)), told(B).
L #sum[     told(P) = W : wlist(S,Q,pos(P),W),
        not told(N) = W : wlist(S,Q,neg(N),W) ] U
                     :- rule(pos(sum(L,S,U)),pos(B)), told(B).
                     :- rule(pos(false),     pos(B)), told(B).

% check dominance of counterexample

 :- not optimize(1,1,incl), not err.
 :- minimize(1,S), wlist(S,_,pos(P),1), told(P), not hold(P), not err.
 :- minimize(1,S), wlist(S,_,neg(N),1), hold(N), not told(N), not err.
 :- minimize(1,S),     told(P) : wlist(S,_,pos(P),1) :     hold(P),
                   not told(N) : wlist(S,_,neg(N),1) : not hold(N), not err.

% project output to atoms of answer set and possibly counterexample

#hide.
#show hold/1.
#show told/1.
#show error/1.
#show error.
