#! /bin/bash
instance=$(readlink -f $2)
cd $(dirname $0)
read answerRow

if [ "$answerRow" == "INCONSISTENT" ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "INCONSISTENT" ] && [ $1 == 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "UNKNOWN" ] && [ $1 != 10 ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi

if [ $1 == 20 ]; then
	echo "DONTKNOW"
        echo "Instances with no solution should not be checked with this checker." >&2
        exit 2
else
	if [ $1 != 10 ]; then
		echo "FAIL"
	        exit 1
	else
		systemResult=$((echo "$answerRow" ; cat $instance checker.gringo) | ./clingo --quiet)
		systemReturn=$?

		if [ $systemReturn == 20 ]; then
    			echo "FAIL"
#        		echo "Solver reported incorrect witness." >&2
    			exit 1
		else
			if [ $systemReturn != 10 ]; then
				echo "WARN"
    				echo "Unrecognized input stream or general checker failure." >&2
    				exit 3
			fi
		fi
	fi
fi

echo "OK"

