#! /bin/bash

INST=${INST:=''}
OK=${OK:=''}
ANSWERROW=${ANSWERROW:=''}
# CLINGO=${CLINGO:='clingo'}
# COLOURLP=${COLOURLP:='colour.lp'}
RESULT=${RESULT:=''}
WORKINGDIR=${WORKINGDIR:=''}

WORKINGDIR=`dirname $0`

# read instance
INST=$2

OK=false

# read answer-set
read ANSWERROW

if [ "$INST" == "" ]; then
  echo "usage ./" $0 " returnValue instancefile < resultstring"
  exit 1
fi

if [ "$ANSWERROW" == "INCONSISTENT" ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$ANSWERROW" != "INCONSISTENT" ] && [ $1 == 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$ANSWERROW" != "UNKNOWN" ] && [ $1 != 10 ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi

if [ $1 == 20 ]; then
	echo "DONTKNOW"
        echo "Instances with no solution should not be checked with this checker" >&2
        exit 2
else
	if [ $1 != 10 ]; then
		echo "FAIL"
	        exit 1
	else
		systemResult=$($WORKINGDIR/check_solution.sh $2 "$ANSWERROW")
		if [[ $? -ne 0 ]]
		then
    			echo "WARN"
    			echo "Internal Checker-Error occured." >&2
    			exit 3
		fi

		if [ "$systemResult" == "NOK" ]; then
			OK=false
		elif [ "$systemResult" == "OK" ]; then
			OK=true
		else
			echo "WARN"
    			echo "Internal Checker-Error occured." >&2
    			exit 3
		fi
	fi
fi
if $OK; then
	echo "OK"
	exit 0
else
	echo "FAIL"
	exit 1
fi 
