#hide.
#show put/3.

% extract changes
move(T,Y) :- put(T,X,Y).
put(T,X)  :- put(T,X,Y).

 :- put(T,X),  not disk(X).
 :- move(T,Y), not disk(Y).
 :- move(T,Y), Y < 5.
 :- move(T,Y), not time(T).
 :- move(T,Y), steps(T).

 :- not 1 { put(T,X,Y) : disk(X) : disk(Y) } 1, time(T), not steps(T).

% blocked disks
blocked(T,X) :- disk(X;Y), on(T,X,Y).

 :- move(T,X), blocked(T,X).
 :- put(T,X),  blocked(T,X).
 :- put(T,X),  move(T,Y), Y <= X.

% place disks
on(0,X,Y)   :- on0(Y,X).
on(T+1,X,Y) :- time(T), not steps(T), on(T,X,Y), not move(T,Y), disk(X;Y).
on(T+1,X,Y) :- move(T,Y), put(T,X).

% check goal condition
 :- steps(T), ongoal(X,Y), not on(T,Y,X).
