#! /bin/bash
ok=false

read answerRow

if [ "$answerRow" == "INCONSISTENT" ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "COND1. MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "INCONSISTENT" ] && [ $1 == 20 ]; then
	echo "FAIL"
	echo "COND2. MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "UNKNOWN" ] && [ $1 != 10 ] && [ $1 != 30 ] && [ $1 != 11 ]; then
	echo "FAIL"
	echo "COND3. MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi

if [ $1 == 20 ]; then
	echo "DONTKNOW"
        echo "Instances with no solution should not be checked with this checker" >&2
        exit 2
else
	if [ $1 != 10 ] && [ $1 != 30 ] && [ $1 != 11 ]; then
		echo "FAIL"
		exit 1
	else
		# Get working directory of this script
	        basedir=$(dirname $0)

		# Filter for instance predicates node/1 and edge/2, everything else will be ignored
		filteredInstance=$(cat $2 | grep -o -e 'node([0-9]\+)\.\|edge([0-9]\+,[0-9]\+)\.')

		# Filter for output predicates clique/1, everything else will be ignored
		filteredAnswer=$(echo "$answerRow" | grep -o -e 'clique([0-9]\+)\.')

		# Provide filtered instance and filtered witness
		systemResult=$( (echo "$filteredInstance"; echo "$filteredAnswer") | $basedir/checker)
		returnCode=$?

		case $returnCode in
			0)
				echo $systemResult
				exit 0
				;;
			1)
				echo "FAIL"
				exit 1
				;;
			*)
				echo "WARN"
				echo $systemResult >&2
				exit 3
				;;
		esac
	fi
fi
