#!/bin/bash
#
# Marcello Balduccini
# marcello.balduccini@gmail.com
# [100512] Modified to comply with ASPOCP13 requirements
#

DIRNAME=`dirname $0`
SOLVER="$DIRNAME/dl.bin -n=1 -silent --"
ENCODING=$DIRNAME/constraint.asp
FULL_ENCODING=$DIRNAME/encoding.asp

EXITCODE=$1
shift
INSTANCEFILE=$1
shift

read HEADER


if [ "$EXITCODE" != "0" -a "$HEADER" = "UNKNOWN" ]; then
	RES="FAIL"
else
	RES=""
	case "$EXITCODE" in
		10)
			echo $HEADER | $SOLVER $ENCODING $INSTANCEFILE  | grep -q "^{"
			if [ $? = 0 ]; then
			    RES="OK"
			else
			    RES="FAIL"
			fi
			;;
		20)
			RES="DONTKNOW";
			#if [ "$HEADER" != "INCONSISTENT" ]; then
			#	RES="FAIL"
			#else
			#	$SOLVER $FULL_ENCODING $INSTANCEFILE  | grep -q "^{"
			#	if [ $? = 0 ]; then
			#	    RES="FAIL"
			#	else
			#	    RES="OK"
			#	fi
			#fi
			;;
		*)
			RES="FAIL"
			;;
	esac
fi

case "$RES" in
	"OK")
		echo "OK"
		exit 0
		;;
	"FAIL")
		echo "FAIL"
		exit 1
		;;
	"DONTKNOW")
		echo "DONTKNOW"
		exit 2
		;;
	"WARN"|*)
		echo "WARN"
		exit 3
		;;
esac
