%%%%%%%%%%%%%%%%%
% Preprocessing %
%%%%%%%%%%%%%%%%%

sign(m). sign(p).

nontriv(V)    :- active(V), edge(U,V).
trivial       :- active(V), not nontriv(V).

btedge(W,U,V) :- active(V), edge(W,V), edge(U,V), edge(Z,V), W < Z, Z < U.
ntedge(W,U,V) :- active(V), edge(W,V), edge(U,V), W < U, not btedge(W,U,V).
nfirst(U,V)   :- ntedge(W,U,V).
nlast(W,V)    :- ntedge(W,U,V).
first(U,V)    :- active(V), edge(U,V), not nfirst(U,V).
last(U,V)     :- active(V), edge(U,V), not nlast(U,V).

:- active(V), input(V).
:- active(V), not vertex(V).


%%%%%%%%%%%%%%%%%%%%%%
% Inconsistency Test %
%%%%%%%%%%%%%%%%%%%%%%

vlabel(V,p)   | vlabel(V,m)   :- active(V), not obs_vlabel(V,p),   not obs_vlabel(V,m).
vlabel(U,p)   | vlabel(U,m)   :- active(V), not obs_vlabel(U,p),   not obs_vlabel(U,m),   edge(U,V).
llabel(U,V,p) | llabel(U,V,m) :- active(V), not obs_elabel(U,V,p), not obs_elabel(U,V,m), edge(U,V).

vlabel(V,S)   :- active(V), obs_vlabel(V,S).
vlabel(U,S)   :- active(V), obs_vlabel(U,S),   edge(U,V).
llabel(U,V,S) :- active(V), obs_elabel(U,V,S), edge(U,V).

oppo(U,V)     :- llabel(U,V,m), vlabel(U,S), vlabel(V,S).
oppo(U,V)     :- llabel(U,V,p), vlabel(U,S), vlabel(V,T), S != T.

coppo(U,V)    :- oppo(U,V), first(U,V).
coppo(U,V)    :- oppo(U,V), coppo(W,V), ntedge(W,U,V).

bot           :- trivial.
bot           :- active(V), coppo(U,V), last(U,V).

vlabel(V,S)   :- bot, active(V), sign(S), not obs_vlabel(V,p),   not obs_vlabel(V,m).
vlabel(U,S)   :- bot, active(V), sign(S), not obs_vlabel(U,p),   not obs_vlabel(U,m),   edge(U,V).
llabel(U,V,S) :- bot, active(V), sign(S), not obs_elabel(U,V,p), not obs_elabel(U,V,m), edge(U,V).

:- not bot.


%%%%%%%%%%%%%%%%%%%
% Minimality Test %
%%%%%%%%%%%%%%%%%%%

mvlabel(W,V,p)   | mvlabel(W,V,m)   :- active(W), active(V), W != V.
mvlabel(W,U,p)   | mvlabel(W,U,m)   :- active(W), active(V), W != V, edge(U,V).
mllabel(W,U,V,p) | mllabel(W,U,V,m) :- active(W), active(V), W != V, edge(U,V).

mvlabel(W,V,S)   :- active(W), active(V), W != V, obs_vlabel(V,S).
mvlabel(W,U,S)   :- active(W), active(V), W != V, obs_vlabel(U,S),   edge(U,V).
mllabel(W,U,V,S) :- active(W), active(V), W != V, obs_elabel(U,V,S), edge(U,V).

minfl(W,V,p)     :- mvlabel(W,U,S), mllabel(W,U,V,S).
minfl(W,V,m)     :- mvlabel(W,U,S), mllabel(W,U,V,T), S != T.

:- active(W), active(V), W != V, mvlabel(W,V,S), not minfl(W,V,S).
