#! /bin/bash
ok=false

read answerRow

if [ "$answerRow" == "INCONSISTENT" ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "INCONSISTENT" ] && [ $1 == 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "UNKNOWN" ] && [ $1 != 10 ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi

if [ $1 == 20 ]; then
	echo "DONTKNOW"
        echo "Instances with no solution should not be checked with this checker" >&2
        exit 2
else
	if [ $1 != 10 ]; then
		echo "FAIL"
	        exit 1
	else

                DIRNAME=`dirname $0`
                SOLVER="$DIRNAME/dl.bin -silent --"
                ENCODING=$DIRNAME/constraint.asp

                systemResult=$(echo "$answerRow" | cat - $2 | $SOLVER $ENCODING)
                if [[ $? -ne 0 ]]
                then
                        echo "WARN"
                        echo "Unrecognized input stream or general checker failure." >&2
                        exit 1
                fi

                if [ "$systemResult" == "" ]; then
                        ok=false
                else
                        ok=true
                fi

	fi
fi
if $ok; then
	echo "OK"
else
	echo "FAIL"
	exit 1
fi 
