#! /bin/bash
read answerRow

checker_path="$(dirname "$0")"
gringo_bin=${checker_path}/gringo-aspcomp2014

if [ "$answerRow" == "INCONSISTENT" ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "INCONSISTENT" ] && [ $1 == 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "INCOMPLETE" ] && [ $1 != 10 ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi

if [ $1 == 20 ]; then
	echo "DONTKNOW"
        echo "Instances with no solution should not be checked with this checker" >&2
        exit 2
else
	if [ $1 != 10 ]; then
		echo "FAIL"
	        exit 1
	else
		if [ -z $(echo "$answerRow" | grep -o -e "unit2zone([0-9][0-9]*,[0-9][0-9]*)." -e "unit2sensor([0-9][0-9]*,[0-9][0-9]*)." -e "partnerunits([0-9][0-9]*,[0-9][0-9]*)." | ${gringo_bin} ${checker_path}/constraint.asp ${2} - -t | grep "^checkfailed.") ]; then
	    		echo "OK"
	    		exit 0
		else
	    		echo "FAIL"
	    		exit 1
		fi
	fi
fi
