% each zone as well as each door sensor must be connected to exactly one unit
:- unit2zone(U1,Z), unit2zone(U2,Z), U1!=U2.
:- unit2sensor(U1,D), unit2sensor(U2,D), U1!=U2.

% all zones and door sensors must be connected
connectedZone(Z) :- unit2zone(_,Z).
:- zone2sensor(Z,D), not connectedZone(Z).
connectedSensor(D):- unit2sensor(_,D).
:- zone2sensor(Z,D), not connectedSensor(D).

% each unit can control at most two door sensors and at most two zones
:- comUnit(U), #count{Z: unit2zone(U,Z)}>2.
:- comUnit(U), #count{D: unit2sensor(U,D)}>2.

% if a unit controls a door sensor that contributes to a zone controlled by another unit,
% then the two units must be connected directly , i.e. one unit becomes a partner unit of the other
% and vice versa
:- unit2zone(U,Z), unit2sensor(P,D), zone2sensor(Z,D), not partnerunits(U,P), U!=P.
:- unit2zone(U,Z), unit2sensor(P,D), zone2sensor(Z,D), not partnerunits(P,U), U!=P.
:- partnerunits(U,P), not partnerunits(P,U).
:- partnerunits(U,U).

% each unit can have at most maxPU partner units
:- comUnit(U), #count{P: partnerunits(U,P)}>X, maxPU(X).


