
		%just some tools
		%Symmetric pipe
symm_pipe(A,B):- pipe(A,B).
symm_pipe(B,A):- pipe(A,B).
		%We need a lexicographic order (there may be more than one worst isolation cases)
less_ico(pipe(A,B),pipe(C,D)):- pipe(A,B), pipe(C,D), A<C.
less_ico(pipe(A,B),pipe(C,D)):- pipe(A,B), pipe(C,D), A==C, B<D.

	%swap pipe
swap(pipe(A,B),pipe(A,B)):- pipe(A,B).
swap(pipe(A,B),pipe(B,A)):- pipe(A,B).
	%Adjacency of pipes (common junction and unshared junctions)
adj(pipe(A,B),pipe(C,D),COM,U1,U2):-
		swap(pipe(A,B),pipe(COM,U1)),
		swap(pipe(C,D),pipe(COM,U2)),
		U1!=U2, not tank(COM).

%%%Feasibility checking
	%No pipe, no valve
:- valve(A,B), not symm_pipe(A,B).

	%At most Nv valves can be placed
:- valves_number(Nv), not 1 { valve(A,B) } Nv.

%The net must be disconnected from tanks
:- tank(A), symm_pipe(A,B), not valve(A,B).

%1 or 2 valves per edge are allowed
:- valves_per_pipe(N), N==1, valve(A,B), valve(B,A).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%Checking of objective value
		%
		%There are some valves that are closed to isolate the broken pipe
%
% GB Ianni Jun 20th, 2013, Improved search space.
%
%1 { closed_valve(v(X,Y),broken(A,B)) : symm_pipe(X,Y) } Nv :- pipe(A,B), valves_number(Nv).
%


0 { closed_valve(v(X,Y),broken(A,B)) : symm_pipe(X,Y)  } 1 :- valve(X,Y), pipe(A,B).

		%
		%If a valve is closed for some pipes, then it must be installed!!
% :- closed_valve(v(A,B), _), not valve(A,B).

		%
		%A pipe adjacent to the tank is reached (when a generic pipe is broken) if there is no valve between them.
reached(pipe(A,B),broken(X,Y)):- pipe(X,Y),
			swap(pipe(A,B),pipe(T,D)),
			tank(T),
			not closed_valve(v(T,D), broken(X,Y)).
		%
		%Can we recursively reach any tank??
reached(pipe(A,B),broken(X,Y)):- adj(pipe(A,B),pipe(C,D),COM,U1,U2), %COM is not a tank! 
			not closed_valve(v(COM,U1),broken(X,Y)),
			not closed_valve(v(COM,U2),broken(X,Y)),
			reached(pipe(C,D), broken(X,Y)).

		%
		%The broken pipe must be unreachable!
:- pipe(A,B), reached(pipe(A,B),broken(A,B)).

		%
		% Pair-wise comparisons between delivered demand pipe isolation cases
lower(pipe(X,Y),pipe(W,Z)):- pipe(X,Y), pipe(W,Z),
		#sum [ 	reached(pipe(A,B),broken(X,Y))=Dn: dem(A,B,Dn),
				reached(pipe(C,D),broken(W,Z))=-Dm: dem(C,D,Dm) ] 0.

		%
		%Then the lower are...
lower_lexico(pipe(X,Y),pipe(W,Z)):- pipe(X,Y), pipe(W,Z),
				lower(pipe(X,Y), pipe(W,Z)), not lower(pipe(W,Z),pipe(X,Y)).
lower_lexico(pipe(X,Y),pipe(X,Y)):- pipe(X,Y), lower(pipe(X,Y),pipe(X,Y)).
lower_lexico(pipe(X,Y),pipe(W,Z)):- pipe(X,Y), pipe(W,Z), % with the same delivered demand
				lower(pipe(X,Y),pipe(W,Z)), lower(pipe(W,Z),pipe(X,Y)),
				less_ico(pipe(X,Y),pipe(W,Z)).

		%
		%The worst isolation case is the one for which all lower_lexico are true
worst(pipe(X,Y)):- pipe(X,Y), lower_lexico(pipe(X,Y),pipe(W,Z)) : pipe(W,Z).

worst_deliv_dem(pipe(A,B), D):- dem(A,B,D), pipe(X,Y),
			reached(pipe(A,B),broken(X,Y)), worst(pipe(X,Y)).

		%
		% Maximization of the worst isolation case' delivered demand
#maximize [ worst_deliv_dem(pipe(A,B),D)=D : pipe(A,B) ].

#hide.
