check_symm(A,B,A,B) :- pipe(A,B).
check_symm(A,B,B,A) :- pipe(A,B).

check_symm_pipe(C,D) :- check_symm(A,B,C,D).

:- valve(A,B), not check_symm_pipe(A,B).
:- valve(A,B), valve(B,A), valves_per_pipe(1).
:- check_symm_pipe(A,B), tank(A), not valve(A,B).
:- valves_number(N), not #count{ valve(A,B) } N.

check_break(A,B,A,B) :- pipe(A,B).
check_break(A,B,C,D) :- check_imply(A,B,E), check_symm_pipe(E,F), not valve(E,F), check_symm(C,D,E,F).
check_imply(A,B,E)   :- check_break(A,B,C,D), check_symm(C,D,E,F), not valve(E,F).

check_reach(A,B,C)   :- pipe(A,B), tank(C).
check_reach(A,B,E)   :- check_water(A,B,C,D), check_symm(C,D,E,F), not check_imply(A,B,E).
check_water(A,B,C,D) :- check_reach(A,B,E), check_symm_pipe(E,F), check_symm(C,D,E,F), not check_break(A,B,C,D).

check_cost(N) :- pipe(A,B), N = #sum[ not check_water(A,B,C,D) = M : pipe(C,D) : dem(C,D,M) ].

check_costs :- check_cost(N).

costsum(M) :- check_costs, M = #max[ check_cost(N) = N ].
costsum(0) :- not check_costs.

#hide.
#show costsum/1.
