#! /bin/bash
ok=false
base=$(dirname $0)
read answerRow

if [ "$answerRow" == "INCONSISTENT" ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "INCONSISTENT" ] && [ $1 == 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi
if [ "$answerRow" != "UNKNOWN" ] && [ $1 != 10 ] && [ $1 != 20 ]; then
	echo "FAIL"
	echo "MISMATCH OF SOLVER RETURN VALUE AND STANDARD INPUT" >&2
	exit 1
fi

if [ $1 == 20 ]; then
	echo "DONTKNOW"
        echo "Instances with no solution should not be checked with this checker" >&2
        exit 2
else
	if [ $1 != 10 ]; then
		echo "FAIL"
	        exit 1
	else
		# Filter for output predicate move, everything else will be ignored
		# echo "$answerRow"
		filteredMove=$(echo "$answerRow" | grep -o -P '(\W|^)move\(.+?,.+?,.+?\)\.' | perl -ne 'chomp and print')
		# Provide filtered witness, additionally specify input instance ($2)
		#echo "$filteredMove | gringo ./constraint.asp $2 - | clasp"
		systemResult=$(echo "$filteredMove" | cat $base/constraint.asp $2 - | $base/gringo | $base/clasp)
		chkexit=$?
		if [[ $chkexit -eq 10 ]] ; then
	    		echo "OK"
	    		exit 0
		elif [[ $chkexit -eq 20 ]] ; then
	    		echo "FAIL"
	    		exit 1
#	elif [[ $chkexit -eq 1 && $systemResult =~ (\s)*ERROR ]] ; then
		elif [[ $chkexit -eq 1 ]] ; then
    	    		echo "WARN"
    	    		echo "Unrecognized input stream or general checker failure." >&2
    	    		exit 3
		fi
	fi
fi
