%
% IPC 2011 Visit-all domain
%
%
% ASP Competition 2013 version, by GB Ianni. Adaptment from a plasp PDDL2ASP conversion 
% (http://www.cs.uni-potsdam.de/wv/pdfformat/gekaknsc11a.pdf)
% 
% Solution Checker  
%
% initial status
%
visited(X) :- at(X).
atrobot(X,0) :- at(X).

% EFFECTS APPLY  >>>>>


% move/2, effects
atrobot( Nextpos,T ) :- move( Curpos,Nextpos,T ).
del( atrobot( Curpos ),T ) :- move( Curpos,Nextpos,T ).
visited( Nextpos ) :- move( Curpos,Nextpos,T ).
% <<<<<  EFFECTS APPLY
% 

% 
% 
% INERTIA  >>>>>
atrobot( X,T ) :- step(T), atrobot( X,T-1 ), not del( atrobot( X ) ,T  ).
%
% GB: it is not needed to let 'visited' subject to timestamping 
%
% <<<<<  INERTIA
% 

% 
% 
% PRECONDITIONS HOLD  >>>>>

% move/2, preconditions
 :- move( Curpos,Nextpos,T ), not atrobot(Curpos, T-1), step(T).
% <<<<<  PRECONDITIONS HOLD
% 

doubleMove(X,Y,H,J,T) :- move(X,Y,T), move(H,J,T), X != H.
doubleMove(X,Y,H,J,T) :- move(X,Y,T), move(H,J,T), Y != J.

goalreached(X) :- visited(X), visit(X).
unreachedGoal(X) :- visit(X) , not goalreached(X).



% Gringo directives to show / hide particular literals
%#hide.
%#show move/3.
%#show visited/1.
#hide atrobot/2.
%#hide move/3.
#hide connected/2.
