//////////////////////////////////////////////////////////////////////////////
//extpred.h

#ifndef EXTPRED_H
#define EXPRED_H

#include <assert.h>
#include <iostream>

#include <string>

#define HAVE_GCC_VERSION(MAJOR, MINOR) \
  (__GNUC__ > (MAJOR) || (__GNUC__ == (MAJOR) && __GNUC_MINOR__ >= (MINOR)))

// The character that separates multiple subdirectories in a fully
// qualified filename.
#ifdef __WIN32__
    #define DIR_SEPARATOR '\\'
#else
    #define DIR_SEPARATOR '/'
#endif

namespace std { }

using namespace std;

//////////////////////////////////////////////////////////////////////////////
class CONSTANT
//
    {
public:
    enum TYPE { Integer, Symbol, String, NullConst };

private:
    TYPE type;

    union
        {
        char *string;
	int  integer;
        } data;

public:

    TYPE getType() const;

    bool isInt() const;  

    bool isString() const; 
    
    bool isSymbol() const;

    const char* toString() const; 

    const char* toQuotedString() const;
 
    const char* toSymbol() const;
 
    int toInt() const;

    bool isNull() const; 
    
    CONSTANT();
    
    CONSTANT( const CONSTANT & );

    CONSTANT &operator= ( const CONSTANT & );   
 
    CONSTANT( const char *, bool = false); 

    CONSTANT( const int & );

    ~CONSTANT(); 

    int operator!= ( const CONSTANT & ) const;  
    
    bool operator== ( const CONSTANT & ) const; 

    bool operator< ( const CONSTANT & ) const;
  
    bool operator<= ( const CONSTANT & ) const;
  
    bool operator> ( const CONSTANT & ) const;
 
    bool operator>= ( const CONSTANT & ) const; 

    };

/////////////////////////////////////////////////////////////////////////////
#define BUILTIN( name, pattern ) bool name##_## pattern ( CONSTANT * argv, unsigned argc )

#endif
