/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JButton
extends AbstractButton
implements Accessible {
    private static final String uiClassID = "ButtonUI";
    private boolean defaultCapable = true;

    public JButton() {
        this(null, null);
    }

    public JButton(String string) {
        this(string, null);
    }

    public JButton(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
    }

    public JButton(Icon icon) {
        this(null, icon);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJButton();
        }
        return this.accessibleContext;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isDefaultButton() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            return jRootPane.getDefaultButton() == this;
        }
        return false;
    }

    public boolean isDefaultCapable() {
        return this.defaultCapable;
    }

    protected String paramString() {
        String string = this.defaultCapable ? "true" : "false";
        return String.valueOf(super.paramString()) + ",defaultCapable=" + string;
    }

    public void setDefaultCapable(boolean bl) {
        boolean bl2 = this.defaultCapable;
        this.defaultCapable = bl;
        this.firePropertyChange("defaultCapable", bl2, bl);
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected class AccessibleJButton
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleJButton() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }
}

