dnl
dnl Definitions for creating shared libraries
dnl
dnl The purpose of these definitions is to provide common support for 
dnl shared libraries, with *or without* the use of the GNU Libtool package.
dnl For many of our important platforms, the Libtool approach is overkill,
dnl and can be particularly painful for developers.
dnl
dnl/*D
dnl PAC_ARG_SHAREDLIBS - Add --enable-sharedlibs=kind to configure.
dnl 
dnl Synopsis:
dnl PAC_ARG_SHAREDLIBS
dnl
dnl Output effects:
dnl Adds '--enable-sharedlibs=kind' to the command line.  If this is enabled,
dnl then based on the value of 'kind', programs are selected for the 
dnl names 'CC_SHL' and 'CC_LINK_SHL' that configure will substitute for in
dnl 'Makefile.in's.  These symbols are generated by 'simplemake' when
dnl shared library support is selected.
dnl
dnl Supported values of 'kind' include \:
dnl+    gcc - Use gcc to create both shared objects and libraries
dnl-    none - The same as '--disable-sharedlibs'
dnl
dnl Others will be added as experience dictates.  Likely names are
dnl + libtool - For general GNU libtool
dnl . linux-pgcc - For Portland group under Linux
dnl - solaris-cc - For Solaris C compiler
dnl
dnl Notes:
dnl Shared libraries are only partially implemented.  Additional symbols
dnl will probably be defined, including symbols to specify how shared library
dnl search paths are specified and how shared library names are set.
dnl D*/
AC_DEFUN(PAC_ARG_SHAREDLIBS,[
AC_ARG_ENABLE(sharedlibs,
[--enable-sharedlibs=kind - Enable shared libraries.  kind may be
    gcc     - Standard gcc and GNU ld options for creating shared libraries
    libtool - GNU libtool 
    none    - same as --disable-sharedlibs
Only gcc is currently ignored],
,enable_sharedlibs=none)
dnl
CC_SHL=true
C_LINK_SHL=true
case "$enable_sharedlibs" in 
    no|none)
    ;;
    gcc)
    AC_MSG_RESULT([Creating shared libraries using GNU])
    # Not quite right yet.  See mpich/util/makesharedlib
    # Use syntax that works in both Make and the shell
    #C_LINK_SHL='${CC} -shared -Wl,-r'
    C_LINK_SHL='${CC} -shared'
    # For example, include the libname as ${LIBNAME_SHL}
    #C_LINK_SHL='${CC} -shared -Wl,-h,<finallibname>'
    CC_SHL='${CC} -shared -fpic'
    ;;
    libtool)
    AC_MSG_RESULT([Creating shared libraries using libtool (not yet supported)])
    ;;
dnl
dnl Other, such as solaris-cc
    *)
    AC_MSG_WARN([Unknown value $enable_sharedlibs for enable-sharedlibs])
    ;;  
esac
AC_SUBST(CC_SHL)
AC_SUBST(C_LINK_SHL)
])