package it.unical.mat.controller;
import it.unical.mat.domain.User;
import it.unical.mat.service.UserService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class HomeController {

	@Autowired
	private UserService userService;

	@RequestMapping("/register")
	public ModelAndView getRegisterForm(@ModelAttribute("user") User user,
			BindingResult result) {
		ArrayList<String> gender = new ArrayList<String>();
		gender.add("Male");
		gender.add("Female");
		
		ArrayList<String> continent = new ArrayList<String>();
		continent.add("Asia");
		continent.add("South America");
		continent.add("North America");
		continent.add("Africa");
		continent.add("Europa");
		continent.add("Oceania");
		
		Map<String, Object> model = new HashMap<String, Object>();
		model.put("gender", gender);
		model.put("continent", continent);

		return new ModelAndView("Register", "model", model);
	}

	@RequestMapping("/saveUser")
	public ModelAndView saveUserData(@ModelAttribute("user") User user,
			BindingResult result) {
		
		userService.addUser(user);
		
		System.out.println("Save User Data");
		return new ModelAndView("redirect:/userList.html");
	}

	@RequestMapping("/userList")
	public ModelAndView getUserList() {
		Map<String, Object> model = new HashMap<String, Object>();
		model.put("user", userService.getUserList());
		return new ModelAndView("UserDetails", model);
	}
}
