package it.unical.mat.dao.impl;

import it.unical.mat.dao.UserDao;
import it.unical.mat.domain.User;
import it.unical.mat.util.HibernateUtil;

import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class UserDaoImpl implements UserDao{

	public void saveUser(User user) {
		Session session = HibernateUtil.getSessionFactory().openSession();
		Transaction transaction = null;
		try {
			transaction = session.beginTransaction();
			session.save(user);
			transaction.commit();
		} catch (HibernateException e) {
			e.printStackTrace();
			transaction.rollback();
		} finally {
			session.close();
		}
	}

	public List<User> getUser() {
		Session session = HibernateUtil.getSessionFactory().openSession();
		Transaction transaction = null;
		List<User> users = null;
		try {
			transaction = session.beginTransaction();
			
			users= session.createQuery("from User").list();
		} catch (HibernateException e) {
			e.printStackTrace();
			transaction.rollback();
		} finally {
			session.close();
			return users;
		}
	}
}
