package it.unical.mat.util;

import it.unical.mat.domain.User;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {

	private static final SessionFactory sessionFactory;
	
	static {
		try {
			sessionFactory = new Configuration()
								.configure(ClassLoader.getSystemResource("hibernate.cfg.xml"))
								.addPackage("it.unical.mat.domain") 
								.addAnnotatedClass(User.class)
								.buildSessionFactory();
		} catch (Throwable ex) {
			System.err.println("Initial SessionFactory creation failed." + ex);
			throw new ExceptionInInitializerError(ex);
		}
	}

	public static SessionFactory getSessionFactory() {
		return sessionFactory;
	}
}
