package gerarchie.joinedTables;


import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;

import utils.HibernateUtil;

public class InserisciValori {

	public static void main(String[] args) {
		
		Configuration configuration = new Configuration();
	    configuration.configure("/gerarchie/joinedTables/hibernate.cfg.xml");
	    ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings(configuration.getProperties()).buildServiceRegistry();        
	    SessionFactory sessionFactory = configuration.buildSessionFactory(serviceRegistry);
		
		
        Session session = sessionFactory.openSession(); 
		creaSchema(sessionFactory);
		interrogaBaseDiDati(sessionFactory);
		sessionFactory.close(); 
	}

	private static void interrogaBaseDiDati(SessionFactory sessionFactory) {
		Session newSession = sessionFactory.openSession();
		Transaction newTransaction = newSession.beginTransaction();
		
		System.out.println("COLLABORATORI");
		List<Collaboratore> collaboratori = newSession.createQuery("from Collaboratore").list();
		for (Collaboratore st : collaboratori) {
			System.out.println(st);
		}
		
		System.out.println("DOCENTI");
		List<Docente> docenti = newSession.createQuery("from Docente").list();
		for (Docente st : docenti) {
			System.out.println(st);
		}
		
		System.out.println("RICERCATORI");
		List<Ricercatore> ricercatori = newSession.createQuery("from Ricercatore").list();
		for (Ricercatore st : ricercatori) {
			System.out.println(st);
		}
		
		newTransaction.commit();
		newSession.close();
	}

	private static void creaSchema(SessionFactory sessionFactory) {
		Session session = sessionFactory.openSession();
		Transaction tx = session.beginTransaction();
		Docente d = new Docente();
		d.setCognome("Leone");
		d.setName("Nicola");
		d.setDipartimento("Matematica");
		
		Collaboratore c = new Collaboratore();
		c.setCognome("Pinco");
		c.setName("Pallo");
		c.setContratto("docente");
		
		session.save(d);
		session.save(c);
		tx.commit();
		session.close();
	}
	

}
