package gerarchie.joinedTables;

import java.io.Serializable;

import javax.persistence.*;



@Entity
@Table(name="RICERCATORI")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class Ricercatore implements Serializable, Comparable{
	
	@Id @GeneratedValue
	@Column(name = "ID_RICERCATORE", nullable = false)
	private Integer idRicercatore;
	
	@Column(name = "NOME", nullable = false)
	private String name;
	
	@Column(name = "COGNOME", nullable = false)
	private String cognome;
	
	public Ricercatore() {
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCognome() {
		return cognome;
	}

	public void setCognome(String cognome) {
		this.cognome = cognome;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((cognome == null) ? 0 : cognome.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Ricercatore other = (Ricercatore) obj;
		if (cognome == null) {
			if (other.cognome != null)
				return false;
		} else if (!cognome.equals(other.cognome))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

	public Integer getIdRicercatore() {
		return idRicercatore;
	}

	public void setIdRicercatore(Integer idRicercatore) {
		this.idRicercatore = idRicercatore;
	}
	
}
