package gerarchie.singleTable;


import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;

import utils.HibernateUtil;

public class InserisciValori {

	public static void main(String[] args) {
		Configuration configuration = new Configuration();
	    configuration.configure("/gerarchie/singleTable/hibernate.cfg.xml");
	    ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings(configuration.getProperties()).buildServiceRegistry();        
	    SessionFactory sessionFactory = configuration.buildSessionFactory(serviceRegistry);
		
		
		creaSchema(sessionFactory);
		interrogaBaseDiDati(sessionFactory);
		sessionFactory.close(); 
	}
	
	private static void interrogaBaseDiDati(SessionFactory sessionFactory) {
		Session session2 = sessionFactory.openSession();
		Transaction tx2 = session2.beginTransaction();
		List list = session2.createQuery("from Docente").list();
		for (Object object : list) {
			System.out.println(object);
		}
		tx2.commit();
		session2.close();
	}

	private static void creaSchema(SessionFactory sessionFactory) {
		Session session = sessionFactory.openSession();
		Transaction tx = session.beginTransaction();
		Docente d = new Docente();
		d.setCognome("Leone");
		d.setName("Nicola");
		d.setDipartimento("Matematica");
		
		Collaboratore c = new Collaboratore();
		c.setCognome("Pinco");
		c.setName("Pallo");
		c.setContratto("Docente");
		
		session.save(d);
		session.save(c);

		tx.commit();
		session.close();
	}


}
