package spring;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		
		ApplicationContext ap = new ClassPathXmlApplicationContext("spring/spring-context.xml");
		
		//Basic bean
		Nuotatore n = (Nuotatore) ap.getBean("Phelps");
		
		n.allenati();
		
		//Constructor injection
		Nuotatore n2 = (Nuotatore) ap.getBean("Pellegrini");

		n2.allenati();
		
		//Dependency injection
		Allenatore a = (Allenatore) ap.getBean("Trap");
		
		System.out.println(" ** Inizia l'allenamento con il Trap ");
		
		a.getAllievo().allenati();
		
		
		//Prototype scope
		
		Nuotatore nsingleton1 = (Nuotatore) ap.getBean("Phelps");

		Nuotatore nsingleton2 = (Nuotatore) ap.getBean("Phelps");

		System.out.println(nsingleton1 + " - " + nsingleton2);
		
		
		Nuotatore nprototype1 = (Nuotatore) ap.getBean("n1");
		
		Nuotatore nprototype2 = (Nuotatore) ap.getBean("n1");
		
		System.out.println(nprototype1 + " - " + nprototype2);
		/*
		
		//Init and Destroy
				
		ConfigurableApplicationContext cap = new ClassPathXmlApplicationContext("spring/spring-context.xml");

		Calciatore c = (Calciatore) cap.getBean("Baggio");
		
		cap.close();
		
		//Simple properties injection
		
		Calciatore baggio = (Calciatore) ap.getBean("Baggio");
		
		Calciatore delpiero = (Calciatore) ap.getBean("Del Piero");
		
		baggio.allenati();
		delpiero.allenati();
		
		baggio.allenati();
		
		
		//Bean dependency injection
		Allenatore mancini = (Allenatore) ap.getBean("Mancini");
		System.out.println(" ** Inizia l'allenamento con il Mancini");
		
		mancini.getAllievo().allenati();
		
		Allenatore benitez = (Allenatore) ap.getBean("Benitez");

		System.out.println(" ** Inizia l'allenamento con il Benitez");

		benitez.getAllievo().allenati();

		*/
		
		
	}

}
