package reflection;

import java.lang.reflect.Field;

public class ClassInspector {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		Class1 class1=new Class1();
		
		System.out.println(ClassInspector.inspectClass(class1));
	}
	
	public static String inspectClass(Object o)
	{
		StringBuffer bf=new StringBuffer();
		
		Class<?> c=o.getClass();
		
		bf.append("The Class name is "+c.getName()+"\n\n");
		
		if(c.isAnnotationPresent(ClassAnnotation.class))
		{
			bf.append("Description: "+c.getAnnotation(ClassAnnotation.class).description());
			
			bf.append("\n\n");
			
			Field[] fields=c.getDeclaredFields();
			
			for(Field f:fields)
			{
				bf.append(f.getName()+"\n");
				if(f.isAnnotationPresent(FieldAnnotation.class))
				{
					bf.append("Description: "+f.getAnnotation(FieldAnnotation.class).description());				}
				
				bf.append("\n\n");
			}
		
		}
		return bf.toString();
	}

}
