package comment;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class CommentPanel extends JPanel{
	JTextArea txtComment = new JTextArea();	
	JButton butShowMore = new JButton("Show more...");
	JButton butEdit = new JButton("Edit");
	JButton butApply = new JButton("Apply");
	JButton butUndo = new JButton("Undo");	
	boolean isMore = false;
	
	CommentMemento commentMemento;
	
	Comment comment;
	
	public CommentPanel() {
		txtComment.setRows(10);
		txtComment.setColumns(40);
		txtComment.setEditable(false);
		butUndo.setEnabled(false);
		butApply.setEnabled(false);
		
		add(new JScrollPane(txtComment));
		add(butShowMore);
		add(butEdit);
		add(butApply);
		add(butUndo);
		
		butShowMore.addActionListener(new ActionListener() {			
			@Override
			public void actionPerformed(ActionEvent arg0) {			
				showMore();
				isMore = true;									
			}
		});
		
		butEdit.addActionListener(new ActionListener() {			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				showMore();
				startEdit();				
			}
		});
		
		butUndo.addActionListener(new ActionListener() {			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				undo();
			}
		});
		
		butApply.addActionListener(new ActionListener() {			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				apply();
			}
		});
		
		load();
	}
	
	private void load(){
		comment = new ProxyComment();
		txtComment.setText(comment.getText());
	}
	
	private void showMore(){
		if (!isMore){						
			txtComment.setText(comment.getText());
		}
	}	
		
	private void startEdit(){
		butShowMore.setEnabled(false);
		butEdit.setEnabled(false);
		butApply.setEnabled(true);
		butUndo.setEnabled(true);
		txtComment.setEditable(true);
		apply();
	}
	
	private void undo(){
		comment.setMemento(commentMemento);
		refresh();
	}
	
	private void apply(){
		comment.setText(txtComment.getText());
		commentMemento = comment.createMemento();		
	}
	
	private void refresh(){
		txtComment.setText(comment.getText());
	}
}
