package comment;

public class ProxyComment implements Comment {
	RealComment comment = null;	
	
	@Override
	public String getText() {		
		if (comment == null){				
			comment = new RealComment();				
		}
		return comment.getText();		
	}

	@Override
	public void setMemento(CommentMemento memento) {		
		if (comment == null){				
			comment = new RealComment();				
		}
		comment.setMemento(memento);		
	}

	@Override
	public CommentMemento createMemento() {
		if (comment == null){				
			comment = new RealComment();				
		}
		return comment.createMemento();
	}
	
	@Override
	public void setText(String text) {
		if (comment == null){				
			comment = new RealComment();				
		}
		comment.setText(text);
	}

	@Override
	public String getFirstRowText() {
		return "Storing incremental changes. \n";
	}
	

}
