package comment;

public class RealComment implements Comment{
	String text;
	
	public RealComment() {
		text = "Storing incremental changes. \n"
				+ "If MMT are created in a predictable sequence, then Memento can save just the incremental changes. \n"
				+ "E.g. undoable commands in a history list \n"
				+ "A specific order in which commands can be undone and redone => mementos can store just the incremental changes \n";
	}
	
	@Override
	public String getText() {
		return text;
	}
	
	@Override
	public void setText(String text) {
		this.text = text;
	}

	@Override
	public void setMemento(CommentMemento memento) {
		text = memento.getText();
	}

	@Override
	public CommentMemento createMemento() {
		CommentMemento mem = new CommentMemento(); 
		mem.setText(text);
		return mem;
	}	

	@Override
	public String getFirstRowText() {		
		return "Storing incremental changes. \n";
	}	
}
