package mainPackage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import main.Printer;
import calculator.Division;
import calculator.Multiplication;
import calculator.Operation;
import calculator.Subtraction;
import calculator.Sum;

public class Calculator {	
	public static void main(String[] args) {
		Printer.printString("Calculator Application");
				
		try {
			Printer.printString("Insert first operand:");
			BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
			int o1 = Integer.parseInt(reader.readLine());			
			Printer.printString("Insert second operand:");
			int o2 = Integer.parseInt(reader.readLine());
			
			Printer.printString("Choose operation:");
			Printer.printString("1) Sum \n");
			Printer.printString("2) Subtraction \n");
			Printer.printString("3) Multiplication \n");
			Printer.printString("4) Division \n");
			int operation = Integer.parseInt(reader.readLine());
			
			Operation calc = null;
			switch (operation){
			case 1:
				calc = new Sum(o1, o2);		
				break;
			case 2:
				calc = new Subtraction(o1, o2);		
				break;
			case 3:
				calc = new Multiplication(o1, o2);		
				break;
			case 4:
				calc = new Division(o1, o2);		
				break;
			default:
				Printer.printString("Wrong operation");
			}
			if (calc != null){
				Printer.printString("Result : " + calc.executeOperation());
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}	
}
