package tests;

import static org.junit.Assert.assertEquals;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import calculator.Division;
import calculator.Multiplication;
import calculator.Sum;

/**
 * Expression
 * ______RIS2____
 *   __RIS1_ 
 * ( (5 * 6) / 2) # X
 * 
 * @author Kristian
 *
 */
public class GenericTest {
	int RIS1;
	int RIS2;	
		
	@Before
	public void initializeTestCases(){		
		Multiplication molt = new Multiplication(5, 6);
		RIS1 = molt.executeOperation();
		Division div = new Division(RIS1, 2);
		RIS2 = div.executeOperation();
	}
	
	@Test
	public void sum2(){
		Sum calc = new Sum(RIS2, 2);
		
		assertEquals(calc.executeOperation(), 17);
	}
	
	@Test
	public void divide5(){
		Division calc = new Division(RIS2, 5);
		
		assertEquals(calc.executeOperation(), 3);
	}
	
	@Test
	public void multiply10(){
		Multiplication calc = new Multiplication(RIS2, 10);
		
		assertEquals(calc.executeOperation(), 150);
	}
	
	@Test(expected = ArithmeticException.class)
	public void divisionByZero(){
		Division div = new Division(RIS2, 2);
		div.executeOperation();
	}
	
	@After
	public void finalize(){
		RIS1 = 0;		
		RIS2 = 0;
	}
}

