package tests;

import static org.junit.Assert.assertTrue;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import calculator.Division;
import calculator.Multiplication;

/**
 * 5 * 2
 * 5 * 3
 * 5 * 4
 * 5 * 5
 * 
 * @author Kristian
 *
 */

@RunWith(value = Parameterized.class)
public class ParametricTest {
	private int number;	

	public ParametricTest(int number) {	
		this.number = number;
	}			
	
	@Parameters
	 public static Collection data() {
	   Object[][] data = new Object[][] { { 5 }, { 10 }, { 20 }, { 40 } };
	   return Arrays.asList(data);
	 }
	
	@Test
	public void test(){
		System.out.println("Test for " + number);
		if (number < 15){
			Division div = new Division(number, 5);
			int result = div.executeOperation();
			assertTrue( (result == 1) || (result == 2) );  
		}else{
			Multiplication div = new Multiplication(number, 2);
			int result = div.executeOperation();
			assertTrue( (result == 40) || (result == 80) );
		}
	}
}
