package tests;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import calculator.Division;
import calculator.Multiplication;
import calculator.Subtraction;
import calculator.Sum;

public class TestCalculator {
		
	@Test
	public void sum(){				
		Sum calc = new Sum(5, 9);
		assertEquals(14, calc.executeOperation());
		
		calc.setSecondOperand(10);
		assertEquals(15, calc.executeOperation());
		
		calc.setFirstOperand(6);
		assertTrue(calc.executeOperation() == 16);
		assertFalse(calc.executeOperation() < 16);
	}
	
	@Test
	public void subtraction(){				
		Subtraction calc = new Subtraction(10, 5);
		assertEquals(5, calc.executeOperation());
		
		calc.setSecondOperand(10);
		assertEquals(0, calc.executeOperation());
		
		calc.setFirstOperand(6);
		assertFalse(calc.executeOperation() > 0);	
	}
	
	@Test
	public void multiplication(){				
		Multiplication calc = new Multiplication(5, 8);		
		assertEquals(40, calc.executeOperation());
		
		calc.setSecondOperand(10);
		assertEquals(50, calc.executeOperation());
		
		calc.setFirstOperand(6);
		assertTrue(calc.executeOperation() > 0);	
	}
	
	@Test
	public void division(){				
		Division calc = new Division(10, 5);		
		assertEquals(2, calc.executeOperation());
		
		calc.setSecondOperand(10);
		assertEquals(1, calc.executeOperation());
		
		calc.setFirstOperand(6);		
		assertTrue(calc.executeOperation() < 1);
	}
}
