package textFormatting;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JLabel;

import formatting.Format;
import formatting.FormatHtml;
import formatting.FormatOneRow;


public class TextHtml extends TextView{
	JLabel component;
	
	public TextHtml(){
		initialize();
	}	
	
	public JLabel getComponent() {
		return component;
	}	
		
	private void initialize(){
		component = new JLabel();
		component.setPreferredSize(new Dimension(450, 200));
		component.setMinimumSize(new Dimension(450, 200));
		component.setMaximumSize(new Dimension(450, 200));
		component.setOpaque(true);
		component.setBackground(Color.WHITE);	
//		setFormat(new FormatHtml());
	}
	
	@Override
	public void handleFormat(Format format) {
		if (format instanceof FormatHtml){
			visualize(format.doFormat(component.getText()));
		}
		super.handleFormat(format);
	}
	
	@Override
	public void visualize(String text) {		
		component.setText(text);
	}
}
