package textFormatting;

import java.awt.Color;

import javax.swing.JTextArea;

import formatting.Format;
import formatting.FormatOneRow;


public class TextNormalRow extends TextView{
	JTextArea component;
	
	public TextNormalRow() {
		initialize();
	}
	
	public JTextArea getComponent() {
		return component;
	}
	
	private void initialize(){
		component = new JTextArea(10, 40);
		component.setEditable(false);
		component.setBackground(Color.WHITE);
//		setFormat(new FormatOneRow());
	}
	
	@Override
	public void handleFormat(Format format) {
		if (format instanceof FormatOneRow){
			visualize(format.doFormat(component.getText()));
		}
		super.handleFormat(format);
	}
		
	@Override
	public void visualize(String text) {		
		component.setText(text);
	}
}
