package textFormatting;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import formatting.FormatHtml;
import formatting.FormatOneRow;

public class TextPanel extends JPanel{
	TextView txtNormalRow;
	TextView txtMultiRows;
	TextView textHtml;
	
	JButton butHtml = new JButton("Format HTML");
	JButton butOneRow = new JButton("Format One Row");;
	
	public TextPanel(String text) {
		txtNormalRow = new TextNormalRow();
		txtMultiRows = new TextNormalMultiRow();
		textHtml = new TextHtml();
		
		this.add(new JLabel("Normal One Row"));
		this.add(new JScrollPane(txtNormalRow.getComponent()));
		this.add(new JLabel("Normal Text"));
		this.add(new JScrollPane(txtMultiRows.getComponent()));
		this.add(new JLabel("Html Text"));
		this.add(new JScrollPane(textHtml.getComponent()));
		this.add(butHtml);
		this.add(butOneRow);
		
		txtNormalRow.showText(text);
		txtMultiRows.showText(text);
		textHtml.showText(text);
		
		txtNormalRow.setSuccessor(txtMultiRows);
		txtMultiRows.setSuccessor(textHtml);
		
		butHtml.addActionListener(new ActionListener() {			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				txtNormalRow.handleFormat(new FormatHtml());
			}
		});
		
		butOneRow.addActionListener(new ActionListener() {			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				txtNormalRow.handleFormat(new FormatOneRow());
			}
		});
	}
}
