/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.languages.asp;

import it.unical.mat.embasp.languages.Mapper;
import it.unical.mat.embasp.languages.asp.IllegalTermException;
import it.unical.mat.embasp.languages.asp.SymbolicConstant;
import it.unical.mat.parsers.asp.ASPParser;
import java.util.HashMap;

public class ASPMapper
extends Mapper {
    private static ASPMapper mapper;

    public static ASPMapper getInstance() {
        if (mapper == null) {
            mapper = new ASPMapper();
        }
        return mapper;
    }

    private ASPMapper() {
    }

    @Override
    protected String getActualString(String predicate, HashMap<Integer, Object> parametersMap) throws IllegalTermException {
        if (parametersMap.isEmpty()) {
            return predicate;
        }
        String atom = predicate + "(";
        for (int i = 0; i < parametersMap.size(); ++i) {
            Object objectTerm;
            if (i != 0) {
                atom = atom + ",";
            }
            if ((objectTerm = parametersMap.get(i)) == null) {
                throw new IllegalTermException("Wrong term number of predicate " + predicate);
            }
            atom = objectTerm instanceof Integer ? atom + objectTerm + "" : (objectTerm instanceof SymbolicConstant ? atom + objectTerm.toString() + "" : atom + "\"" + objectTerm.toString() + "\"");
        }
        atom = atom + ")";
        return atom;
    }

    @Override
    protected String getId(String atom) {
        int openBracketIndex = atom.indexOf("(");
        if (openBracketIndex == -1) {
            return atom;
        }
        return atom.substring(0, openBracketIndex);
    }

    @Override
    protected String[] getParam(String atom) {
        return ASPParser.parse(atom).getParameters();
    }
}

