/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.specializations.dlv.android;

import android.app.IntentService;
import android.content.Intent;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.TimeUnit;

public class DLVAndroidReasoner
extends IntentService {
    public static final String FILENAME = "tmp_program";
    public static final String ACTION_SOLVE = "it.unical.mat.embasp.specializations.dlv.android.SOLVE";
    public static final String PROGRAM = "it.unical.mat.embasp.specializations.dlv.android.PROGRAM";
    public static final String OPTION = "it.unical.mat.embasp.specializations.dlv.android.OPTION";
    public static final String FILES = "it.unical.mat.embasp.specializations.dlv.android.FILES";
    public static final String SOLVER_RESULT = "it.unical.mat.embasp.specializations.dlv.android.SOLVER_RESULT";
    public static final String RESULT_NOTIFICATION = "it.unical.mat.embasp.specializations.dlv.android.RESULT_NOTIFICATION";

    public DLVAndroidReasoner() {
        super("dlv_service");
    }

    protected void onHandleIntent(Intent intent) {
        String action;
        if (intent != null && ACTION_SOLVE.equals(action = intent.getAction())) {
            String program = intent.getStringExtra(PROGRAM);
            String options = intent.getStringExtra(OPTION);
            String files = intent.getStringExtra(FILES);
            String result = this.handleActionSolve(program, options, files);
            Log.i((String)"result", (String)result);
            this.publishResults(result);
        }
    }

    private void publishResults(String result) {
        Intent intent = new Intent(RESULT_NOTIFICATION);
        intent.putExtra(SOLVER_RESULT, result);
        this.sendBroadcast(intent);
    }

    protected String handleActionSolve(String program, String options, String filesPath) {
        Log.i((String)"DLV", (String)"Launching DLV");
        File file = new File(this.getFilesDir(), FILENAME);
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            outputStream.write(program.getBytes());
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder completeProgram = new StringBuilder();
        completeProgram.append(options).append(" ");
        completeProgram.append(file.getAbsolutePath()).append(" ");
        completeProgram.append(filesPath).append(" ");
        long startTime = System.nanoTime();
        String result = this.dlvMain(completeProgram.toString());
        long stopTime = System.nanoTime();
        Log.i((String)"DLV", (String)("Execution Time: " + Long.toString(TimeUnit.NANOSECONDS.toMillis(stopTime - startTime))));
        return result;
    }

    private native String dlvMain(String var1);

    public void onDestroy() {
        super.onDestroy();
        Process.killProcess((int)Process.myPid());
    }

    static {
        System.loadLibrary("dlvJNI");
    }
}

