/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.specializations.solver_planning_domains;

import it.unical.mat.embasp.base.InputProgram;
import it.unical.mat.embasp.languages.pddl.PDDLException;
import it.unical.mat.embasp.languages.pddl.PDDLInputProgram;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public abstract class SPDUtility {
    private final String solverUrl = "http://solver.planning.domains/solve";

    private static final String escape(String escapable) {
        StringBuilder builder = new StringBuilder();
        block10: for (int i = 0; i < escapable.length(); ++i) {
            char character = escapable.charAt(i);
            switch (character) {
                case '\"': {
                    builder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block10;
                }
                case '/': {
                    builder.append("\\/");
                    continue block10;
                }
                default: {
                    if (character >= '\u0000' && character <= '\u001f' || character >= '\u007f' && character <= '\u009f' || character >= '\u2000' && character <= '\u20ff') {
                        String characterHexCode = Integer.toHexString(character);
                        builder.append("\\u");
                        for (int k = 0; k < 4 - characterHexCode.length(); ++k) {
                            builder.append("0");
                        }
                        builder.append(characterHexCode.toUpperCase());
                        continue block10;
                    }
                    builder.append(character);
                }
            }
        }
        return builder.toString();
    }

    public String createJson(List<InputProgram> pddlInputProgram) throws PDDLException {
        String problem = "";
        String domain = "";
        block4: for (InputProgram ip : pddlInputProgram) {
            if (!(ip instanceof PDDLInputProgram)) continue;
            PDDLInputProgram pip = (PDDLInputProgram)ip;
            switch (pip.getProgramsType()) {
                case DOMAIN: {
                    domain = domain + pip.getPrograms() + pip.getSeparator();
                    domain = domain + this.getFromFile(pip.getFilesPaths(), pip.getSeparator());
                    continue block4;
                }
                case PROBLEM: {
                    problem = problem + pip.getPrograms() + pip.getSeparator();
                    problem = problem + this.getFromFile(pip.getFilesPaths(), pip.getSeparator());
                    continue block4;
                }
            }
            throw new PDDLException("Program type : " + (Object)((Object)pip.getProgramsType()) + " not valid.");
        }
        if (problem.equals("")) {
            throw new PDDLException("Problem file not specified");
        }
        if (domain.equals("")) {
            throw new PDDLException("Domain file not specified");
        }
        return "{\"problem\":\"" + SPDUtility.escape(problem) + "\", \"domain\":\"" + SPDUtility.escape(domain) + "\"}";
    }

    private String getFromFile(List<String> filesPaths, String separator) {
        StringBuilder toReturn = new StringBuilder();
        for (String s : filesPaths) {
            try {
                toReturn.append(this.readFile(s)).append(separator);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return toReturn.toString();
    }

    public String postJsonToURL(String json) throws PDDLException {
        String result = "";
        try {
            BufferedReader br;
            URL myurl = new URL("http://solver.planning.domains/solve");
            HttpURLConnection con = (HttpURLConnection)myurl.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Method", "POST");
            OutputStream os = con.getOutputStream();
            os.write(json.getBytes("UTF-8"));
            os.flush();
            os.close();
            StringBuilder sb = new StringBuilder();
            int HttpResult = con.getResponseCode();
            if (HttpResult == 200) {
                br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
            } else {
                throw new PDDLException("HTTP connection error, response code : " + con.getResponseCode() + " response message : " + con.getResponseMessage());
            }
            br.close();
            result = sb.toString();
        }
        catch (Exception e) {
            throw new PDDLException("Impossible to perform HTTP connection: " + e.getMessage());
        }
        return result;
    }

    protected abstract String readFile(String var1) throws IOException;
}

