import it.unical.mat.embasp.base.Handler;
import it.unical.mat.embasp.base.InputProgram;
import it.unical.mat.embasp.base.OptionDescriptor;
import it.unical.mat.embasp.base.Output;
import it.unical.mat.embasp.languages.asp.ASPInputProgram;
import it.unical.mat.embasp.languages.asp.ASPMapper;
import it.unical.mat.embasp.languages.asp.AnswerSet;
import it.unical.mat.embasp.languages.asp.AnswerSets;
import it.unical.mat.embasp.languages.asp.SymbolicConstant;
import it.unical.mat.embasp.platforms.desktop.DesktopHandler;
import it.unical.mat.embasp.specializations.dlv.desktop.DLVDesktopService;
import it.unical.mat.embasp.specializations.dlv2.desktop.DLV2DesktopService;

public class MainClass {

	public MainClass() {}
	
	private static String encodingResource="encodings/3col";
	private static String instanceResource="encodings/3col-instance";
	private static Handler handler;
	
//	private static String encoding = "col(X,red) | col(X,blue) | col(X,green) :- node(X).\r\n" 
//	                               + ":- col(X,C), col(Y,C), arc(X,Y).";
//	private static String instance = " node(1..5).\r\n" + 
//									  "arc(1,2).\r\n" + 
//			                          "arc(1,3).\r\n" + 
//								      "arc(2,3).\r\n" + 
//								      "arc(4,5).\r\n" + 
//								      "arc(1,4).";
								
	public static void main(String[] args) {
		//Creazione dell'oggetto handler che si occuper di gestire l'invocazione 
		//del sistema ASP da utilizzare. Dal momento che in questa demo si fa uso 
		//di DLV si noti che viene utilizzato un DLVDesktopService.
		
		//Se si esegue la demo su Windows 64bit decommentare una delle seguenti istruzioni:
		//Per usare DLV
		handler = new DesktopHandler(new DLVDesktopService("lib/dlv.mingw.exe"));
		//Per usare DLV2
		//handler = new DesktopHandler(new DLV2DesktopService("lib/dlv2.exe"));	
		
		//Se si esegue la demo su Linux 64bit decommentare una delle seguenti istruzioni:
		//Per usare DLV
		//handler = new DesktopHandler(new DLVDesktopService("lib/dlv"));
		//Per usare DLV2
		//handler = new DesktopHandler(new DLV2DesktopService("lib/dlv2"));	
		
		//Se si esegue la demo su MacOS 64bit decommentare una delle seguenti istruzioni:
		//Per usare DLV
		//handler = new DesktopHandler(new DLVDesktopService("lib/dlv.i386-apple-darwin.bin"));
		//Per usare DLV2
		//handler = new DesktopHandler(new DLV2DesktopService("lib/dlv2-mac"));	
				
		//In alternativa, eseguire i seguenti step e decommentare la seguente istruzione:
		// - aggiungere nella cartella lib l'eseguibile di DLV/DLV2 appropriato in base al proprio sistema:
		// - sostituire a "nome_exe" il nome dell'eseguibile nella seguente istruzione 
		// - se si fa uso di DLV nella seguente istruzione usare DLVDesktopService
		// - se si fa uso di DLV2 nella seguente istruzione usare DLVDesktopService
		//handler = new DesktopHandler(new DLV/DLV2DesktopService("lib/nome_exe"));	
		
		//Se si fa uso di DLV2 e si vogliono ottenere tutti gli answerset, 
		//decommentare le seguenti linee che aggiungono l'opzione -n 0
		//OptionDescriptor option=new OptionDescriptor("-n 0");
		//handler.addOption(option);
		
		//Specifichiamo encoding (ovvero il programma logico) e i fatti tramite file.
		InputProgram  program = new ASPInputProgram();
		program.addFilesPath(encodingResource);
		program.addFilesPath(instanceResource);
		
		//In alternativa, possiamo fornire encoding e i fatti tramite 
		//le stringhe encoding e instance dichiarate e inizializzate sopra.
		//program.addProgram(encoding);
		//program.addProgram(instance);
		
		//Specifichiamo che il nodo 1 deve essere colorato in rosso.
		//Si noti che la classe Col viene prima registrata all'ASPMapper.
		try {
			ASPMapper.getInstance().registerClass(Col.class);
			program.addObjectInput(new Col(1,new SymbolicConstant("red")));
		} catch (Exception e) {
			e.printStackTrace();
		}
		//Aggiungiamo all'handler il programma logico comprensivo di encoding e fatti.
		handler.addProgram(program);
		
		//L'handler invoca DLV in modo SINCRONO dando come input il programma logico e i fatti.
		Output o =  handler.startSync();
		
		//Stampiamo su standard output ogni answerset ottenuto.
		AnswerSets answers = (AnswerSets) o;
		int n=0;
		for(AnswerSet a:answers.getAnswersets()){
			System.out.println("AS n.: " + ++n);
			try {

				for(Object obj:a.getAtoms()){
					if(obj instanceof Col)  {
						Col col = (Col) obj;
						System.out.print(col + " ");
					}
				}
				System.out.println();
			} catch (Exception e) {
				e.printStackTrace();
			} 			
		}
	}
}

	
	