#import_sql(relDB, "user", "pwd", "SELECT * FROM question", question).

#import_local_sparql("answers.rdf", "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX my: <http://sample/rdf#> SELECT ?St, ?Qe, ?Ans WHERE {?X rdf:type my:test. ?X my:student ?St. ?X my:question ?Qe. ?X my:answer ?Ans.}", answer, 3, type:U_INT,U_INT,Q_CONST).

%%% Sample Facts %%%
%question(1,"Maths","A?",a).
%question(2,"English","A?",b).
%question(3,"Maths","A?",a).
%answer(123,1,a).
%answer(123,2,b).
%answer(124,1,b).
%answer(124,2,b).
%%%%%%

%@global_external_predicate_conversion(@predicate=&assignScore,@type=@R_INT).

student(St) :- answer(St,_,_).
topic(To) :- question(_,To,_,_).

correctAnswers(St, To, N) :- topic(To), student(St), N = #count{QID: question(QID, To, Tx, Ca), answer(St, QID, Ca)}.

wrongAnswers(St, To, N) :- topic(To), student(St), N = #count{QID: question(QID, To, Tx, Ca), answer(St, QID, Ans), Ans!=Ca}.

topicScore(St, To, Sc) :- correctAnswers(St, To, Cn), wrongAnswers(St, To, Wn), &assignScore(To, Cn, Wn; Sc).

testScore(St, Sc) :- student(St), Sc = #sum{Sc: topicScore(St, To, Sc)}.
