/*
 * Decompiled with CFR 0.152.
 */
package it.unical.mat.embasp.languages.datalog;

import it.unical.mat.embasp.languages.Mapper;
import it.unical.mat.embasp.languages.asp.IllegalTermException;
import it.unical.mat.embasp.languages.asp.SymbolicConstant;
import it.unical.mat.parsers.datalog.DatalogParser;
import java.util.HashMap;

public class DatalogMapper
extends Mapper {
    private static DatalogMapper mapper;

    public static DatalogMapper getInstance() {
        if (mapper == null) {
            mapper = new DatalogMapper();
        }
        return mapper;
    }

    private DatalogMapper() {
    }

    @Override
    protected String getActualString(String predicate, HashMap<Integer, Object> parametersMap) throws IllegalTermException {
        if (parametersMap.isEmpty()) {
            return predicate;
        }
        StringBuilder atom = new StringBuilder(predicate + "(");
        for (int i = 0; i < parametersMap.size(); ++i) {
            Object objectTerm;
            if (i != 0) {
                atom.append(",");
            }
            if ((objectTerm = parametersMap.get(i)) == null) {
                throw new IllegalTermException("Wrong term number of predicate " + predicate);
            }
            if (objectTerm instanceof Integer) {
                atom.append(objectTerm);
                continue;
            }
            if (objectTerm instanceof SymbolicConstant) {
                atom.append(objectTerm.toString());
                continue;
            }
            atom.append("\"").append(objectTerm.toString()).append("\"");
        }
        atom.append(")");
        return atom.toString();
    }

    @Override
    protected String getId(String atom) {
        int openBracketIndex = atom.indexOf("(");
        if (openBracketIndex == -1) {
            return atom;
        }
        return atom.substring(0, openBracketIndex);
    }

    @Override
    protected String[] getParam(String atom) {
        return DatalogParser.parseParametersFromAtom(atom);
    }
}

